/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;

public class CombPar
extends CombSerPar {
    @Override
    void insertSer(CombRLC c) {
        if (this.parent == null) {
            root = new CombSer();
            ((CombSer)CombPar.root).first = this;
            this.parent = c.parent = root;
            this.next = current = c;
            return;
        }
        CombSerPar p = (CombSerPar)this.parent;
        if (p instanceof CombSer) {
            c.parent = p;
            c.next = this.next;
            this.next = current = c;
        } else if (p instanceof CombPar) {
            CombSer s = new CombSer();
            s.parent = p;
            CombRLC prev = this.getPrevious();
            if (prev == this) {
                p.first = s;
                s.next = prev.next;
                this.next = c;
                c.parent = s;
            } else {
                s.next = this.next;
                prev.next = s;
            }
            s.first = this;
            this.parent = c.parent = s;
            this.next = current = c;
        }
    }

    @Override
    void insertPar(CombRLC c) {
        this.getLast().next = current = c;
        c.parent = this;
    }

    @Override
    int getNHor() {
        CombRLC i = this.first;
        int nMax = 0;
        while (i != null) {
            int n = i.getNHor();
            if (n > nMax) {
                nMax = n;
            }
            i = i.next;
        }
        return nMax;
    }

    @Override
    int getNHorFict(int nH) {
        int nMax = 0;
        if (this == root && this == current) {
            return this.getNHor() + nH;
        }
        CombRLC i = this.first;
        while (i != null) {
            int n = i == current ? i.getNHor() + nH : i.getNHorFict(nH);
            if (n > nMax) {
                nMax = n;
            }
            i = i.next;
        }
        return nMax;
    }

    @Override
    int getNVert() {
        CombRLC i = this.first;
        int n = 0;
        while (i != null) {
            n += i.getNVert();
            i = i.next;
        }
        return n;
    }

    @Override
    int getNVertFict(int nV) {
        if (this == root && this == current) {
            return this.getNVert() + nV;
        }
        CombRLC i = this.first;
        int n = 0;
        while (i != null) {
            n = i == current ? (n += i.getNVert() + nV) : (n += i.getNVertFict(nV));
            i = i.next;
        }
        return n;
    }

    @Override
    Complex getResistance() {
        if (this.first == null) {
            return null;
        }
        Complex res = this.first.getResistance();
        if (res.abs() == 0.0) {
            return new Complex(0.0);
        }
        CombRLC i = this.first.next;
        while (i != null) {
            Complex r2 = i.getResistance();
            i = i.next;
            if (r2.abs() == 0.0) {
                return new Complex(0.0);
            }
            if (r2.isInfinite()) continue;
            if (res.isInfinite()) {
                res = r2;
                continue;
            }
            res = res.mul(r2).div(res.add(r2));
        }
        return res;
    }

    @Override
    void arrange(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        int n = this.getNVert() - 1;
        CombRLC i = this.first;
        if (this.getNumber() == 2 && this.first.next instanceof Voltmeter) {
            int y0 = y + h / 2 - n * h / (2 * n + 4);
            while (i != null) {
                int h0 = i.getNVert() * h / (n + 2);
                i.arrange(x + 20, y0, w - 40, h0);
                y0 += h0;
                i = i.next;
            }
        } else {
            int y0 = y;
            ++n;
            while (i != null) {
                int h0 = i.getNVert() * h / n;
                i.arrange(x + 20, y0, w - 40, h0);
                y0 += h0;
                i = i.next;
            }
        }
    }

    @Override
    void paint(Graphics2D g) {
        if (this.getNumber() == 2 && this.first.next instanceof Voltmeter) {
            this.paintSpecial(g);
            return;
        }
        this.emphasize(g);
        CombRLC i = this.first;
        int y1 = 0;
        int y0 = i.y + i.h / 2;
        g.setColor(Color.black);
        while (i != null) {
            boolean node;
            i.paint(g);
            if (i.next == null) {
                y1 = i.y + i.h / 2;
            }
            int yy = i.y + i.h / 2;
            boolean bl = node = i != this.first && i.next != null;
            if (node) {
                Canvas6.circle(g, this.x + 10, yy, 2.5, Color.black);
                Canvas6.circle(g, this.x + this.w - 10, yy, 2.5, Color.black);
            }
            if (i instanceof Resistor) {
                Canvas6.line(g, this.x + 10, yy, i.x + i.w / 2 - 30, yy);
                Canvas6.line(g, i.x + i.w / 2 + 30, yy, this.x + this.w - 10, yy);
            } else {
                Canvas6.line(g, this.x + 10, yy, this.x + 20, yy);
                Canvas6.line(g, this.x + this.w - 20, yy, this.x + this.w - 10, yy);
            }
            i = i.next;
        }
        Canvas6.line(g, this.x + 10, y0, this.x + 10, y1);
        Canvas6.line(g, this.x + this.w - 10, y0, this.x + this.w - 10, y1);
        y0 = this.y + this.h / 2;
        Canvas6.line(g, this.x, y0, this.x + 10, y0);
        Canvas6.circle(g, this.x + 10, y0, 2.5, Color.black);
        Canvas6.line(g, this.x + this.w - 10, y0, this.x + this.w, y0);
        Canvas6.circle(g, this.x + this.w - 10, y0, 2.5, Color.black);
    }

    void paintSpecial(Graphics2D g) {
        this.emphasize(g);
        this.first.paint(g);
        this.first.next.paint(g);
        int yWire = this.first.y + this.first.h / 2;
        int yVM = this.first.next.y + this.first.next.h / 2;
        g.setColor(Color.black);
        if (this.first instanceof Resistor) {
            Canvas6.line(g, this.x + 10, yWire, this.first.x + this.first.w / 2 - 30, yWire);
            Canvas6.line(g, this.first.x + this.first.w / 2 + 30, yWire, this.x + this.w - 10, yWire);
        } else {
            Canvas6.line(g, this.x + 10, yWire, this.x + 20, yWire);
            Canvas6.line(g, this.x + this.w - 20, yWire, this.x + this.w - 10, yWire);
        }
        Canvas6.line(g, this.x + 10, yVM, this.x + 10, yWire);
        Canvas6.line(g, this.x + this.w - 10, yVM, this.x + this.w - 10, yWire);
        Canvas6.circle(g, this.x + 10, yWire, 2.5, Color.black);
        Canvas6.circle(g, this.x + this.w - 10, yWire, 2.5, Color.black);
        Canvas6.line(g, this.x, yWire, this.x + 10, yWire);
        Canvas6.line(g, this.x + this.w - 10, yWire, this.x + this.w, yWire);
        Canvas6.line(g, this.x + 10, yVM, this.x + 20, yVM);
        Canvas6.line(g, this.x + this.w - 20, yVM, this.x + this.w - 10, yVM);
    }
}

