/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public abstract class CombRLC {
    static final int W2 = 30;
    static final int H2 = 10;
    static final int DIST = 10;
    int x;
    int y;
    int w;
    int h;
    CombRLC parent;
    CombRLC next;
    static double u0 = 12.0;
    static double omega;
    static CombRLC root;
    static CombRLC current;
    static String pt;
    static int digits;
    static Color colorVoltage;
    static Color colorAmperage;
    static Color colorResistance;
    static FontMetrics fmH;
    static String volt;
    static String ampere;
    static String ohm;

    abstract void insertSer(CombRLC var1);

    abstract void insertPar(CombRLC var1);

    void insertAM() {
        this.insertSer(new Amperemeter());
    }

    void insertVM() {
        this.insertPar(new Voltmeter());
    }

    abstract int getNHorFict(int var1);

    abstract int getNHor();

    abstract int getNVertFict(int var1);

    abstract int getNVert();

    abstract Complex getResistance();

    Complex getVoltage() {
        if (this.parent == null) {
            return new Complex(u0);
        }
        Complex u = this.parent.getVoltage();
        if (this.parent instanceof CombSer) {
            Complex r = this.parent.getResistance();
            CombSer ser = (CombSer)this.parent;
            CombRLC i = ser.first;
            if (i == null) {
                return new Complex();
            }
            int n = 0;
            do {
                if (!i.getResistance().isInfinite()) continue;
                ++n;
            } while ((i = i.next) != null);
            if (n == 0) {
                return u.mul(this.getResistance().div(r));
            }
            if (this.getResistance().isInfinite()) {
                return u.div(new Complex(n));
            }
            return new Complex();
        }
        return u;
    }

    String stringVoltage() {
        double u = this.getVoltage().abs();
        return this.doubleToString2(u, digits) + " " + volt;
    }

    Complex getAmperage() {
        Complex u = this.getVoltage();
        Complex r = this.getResistance();
        if (r.abs() == 0.0) {
            if (u.abs() == 0.0) {
                return this.parent.getAmperage();
            }
            return new Complex(Double.POSITIVE_INFINITY);
        }
        if (r.isInfinite()) {
            return new Complex();
        }
        return this.getVoltage().div(this.getResistance());
    }

    String stringAmperage() {
        double i = this.getAmperage().abs();
        return this.doubleToString2(i, digits) + " " + ampere;
    }

    CombRLC getPrevious() {
        if (!(this.parent instanceof CombSerPar)) {
            return null;
        }
        CombRLC i = ((CombSerPar)this.parent).first;
        if (i == null || i == this) {
            return i;
        }
        while (i.next != null && i.next != this) {
            i = i.next;
        }
        return i;
    }

    abstract void arrange(int var1, int var2, int var3, int var4);

    abstract void paint(Graphics2D var1);

    abstract void emphasize(Graphics2D var1);

    CombRLC selectedPart(int xMin, int xMax, int yMin, int yMax) {
        if (!(this instanceof CombSerPar)) {
            return this;
        }
        CombSerPar p = (CombSerPar)this;
        CombRLC i = p.first;
        while (i != null && (xMin < i.x || xMin > i.x + i.w || xMax < i.x || xMax > i.x + i.w || yMin < i.y || yMin > i.y + i.h || yMax < i.y || yMax > i.y + i.h)) {
            i = i.next;
        }
        if (i != null) {
            return i.selectedPart(xMin, xMax, yMin, yMax);
        }
        return this;
    }

    void remove() {
        if (this.parent == null) {
            return;
        }
        if (!(this.parent instanceof CombSerPar)) {
            return;
        }
        CombSerPar p = (CombSerPar)this.parent;
        if (this == p.first) {
            current = p.first = this.next;
        } else {
            current = this.getPrevious();
            CombRLC.current.next = this.next;
        }
        p.simplify();
    }

    boolean isPartOf(CombRLC c) {
        CombRLC i = this;
        do {
            if (i != c) continue;
            return true;
        } while ((i = i.parent) != null);
        return false;
    }

    void replace(CombRLC c) {
        if (this.parent == null) {
            return;
        }
        if (!(this.parent instanceof CombSerPar)) {
            return;
        }
        CombSerPar p = (CombSerPar)this.parent;
        if (this == p.first) {
            p.first = c;
        } else {
            this.getPrevious().next = c;
        }
        c.parent = p;
        c.next = this.next;
    }

    Voltmeter getVoltmeter() {
        if (this instanceof Voltmeter) {
            return (Voltmeter)this;
        }
        if (this instanceof SingleRLC) {
            return null;
        }
        if (this instanceof CombSerPar) {
            CombSerPar c = (CombSerPar)this;
            CombRLC i = c.first;
            while (i != null) {
                Voltmeter vm = i.getVoltmeter();
                if (vm != null) {
                    return vm;
                }
                i = i.next;
            }
            return null;
        }
        return null;
    }

    Amperemeter getAmperemeter() {
        if (this instanceof Amperemeter) {
            return (Amperemeter)this;
        }
        if (this instanceof SingleRLC) {
            return null;
        }
        if (this instanceof CombSerPar) {
            CombSerPar c = (CombSerPar)this;
            CombRLC i = c.first;
            while (i != null) {
                Amperemeter am = i.getAmperemeter();
                if (am != null) {
                    return am;
                }
                i = i.next;
            }
            return null;
        }
        return null;
    }

    String doubleToString(double a, int n) {
        String s;
        String string = s = a >= 0.0 ? "" : "-";
        if (a < 0.0) {
            a = -a;
        }
        long p = 1L;
        for (int i = 0; i < n; ++i) {
            p *= 10L;
        }
        long b = Math.round(a * (double)p);
        s = s + b / p;
        if (n > 0) {
            s = s + pt;
        }
        b %= p;
        for (int i = 0; i < n; ++i) {
            s = s + b / (p /= 10L);
            b %= p;
        }
        return s;
    }

    String doubleToString2(double a, int n) {
        double b = Math.abs(a);
        int z = (int)Math.floor(Math.log(b) / Math.log(10.0));
        String s = a >= 0.0 ? "" : "-";
        return s + this.doubleToString(b, n - 1 - z);
    }
}

