/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class CombinationResistorsAP
extends AP6
implements MouseListener,
MouseMotionListener,
KeyListener {
    static final String[][] text = new String[][]{{"de", "Kombinationen von Widerst\u00e4nden", "Reset", "Spannung der Batterie:", "Widerstand hinzuf\u00fcgen:", "in Serie", "parallel", "Messger\u00e4te:", "Spannung", "Stromst\u00e4rke", "Widerstand:", "Ersatzwiderstand:", "sehr klein", "sehr gro\u00df", ""}, {"en", "Combinations of Resistors", "Reset", "Voltage of the battery:", "Add resistor:", "Series connection", "Parallel connection", "Meters:", "Voltage", "Amperage", "Resistance:", "Equivalent resistance:", "very small", "very large", ""}};
    private int[] gaps = new int[]{10, 10, 5, 10, 5, 10, 10, 10, 5, 5, 20, 0, 10};
    final int width = 800;
    final int height = 450;
    final int width0 = 600;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton buReset;
    JTextField tfU;
    JTextField tfR;
    JButton buSer;
    JButton buPar;
    JCheckBox cbU;
    JCheckBox cbI;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorResistance;
    Color colorVoltage;
    Color colorAmperage;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    static final int digits = 3;
    final double eps = 1.0E-6;
    int y0;
    int y1;
    int xMin;
    int xMax;
    int yMin;
    int yMax;
    double r0;
    Amperemeter am;
    Voltmeter vm;
    CombRLC curr0;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 450);
    }

    @Override
    protected void initAttributes() {
        CombRLC.digits = 3;
        this.r0 = 100.0;
        CombRLC.root = CombRLC.current = new Resistor(this.r0);
        this.arrange();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorResistance = this.getColor(Color.orange, "colorResistance");
        this.colorVoltage = this.getColor(Color.blue, "colorVoltage");
        this.colorAmperage = this.getColor(Color.red, "colorAmperage");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.coauthor = this.getText(t[14], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 600, 450);
        this.add(this.cv);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addKeyListener(this);
        CombRLC.pt = this.getDecimalSeparator(this.language);
        CombRLC.volt = this.volt;
        CombRLC.ampere = this.ampere;
        CombRLC.ohm = this.ohm;
        CombRLC.colorResistance = this.colorResistance;
        CombRLC.colorVoltage = this.colorVoltage;
        CombRLC.colorAmperage = this.colorAmperage;
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(600, 0, 200, 450);
        this.buReset = new ResetButton(this.text01);
        this.pan.add(this.buReset, this.colorButton1, Color.black);
        this.pan.add(this.text02);
        this.tfU = this.pan.newInputField("", this.volt, Color.white, Color.black, 2);
        this.pan.add(this.text03);
        this.tfR = this.pan.newInputField("", this.ohm, Color.white, Color.black, 2);
        this.buSer = this.pan.newButton(this.text04, this.colorResistance, Color.black);
        this.buPar = this.pan.newButton(this.text05, this.colorResistance, Color.black);
        this.pan.add(this.text06);
        this.cbU = this.pan.newCheckBox(this.text07, false);
        this.cbI = this.pan.newCheckBox(this.text08, false);
        this.pan.add(2002);
        this.pan.add(this.coauthor);
        this.updatePanel();
        this.add(this.pan);
        this.buReset.addActionListener(this);
    }

    @Override
    public void run() {
    }

    void updatePanel() {
        this.tfU.setText(this.toString2(CombRLC.u0, 3, 1.0E-6));
        this.tfR.setText(this.toString2(this.r0, 3, 1.0E-6));
        this.buSer.setEnabled(this.vm == null && this.am == null && CombRLC.root.getNHorFict(1) <= 3);
        this.buPar.setEnabled(this.vm == null && this.am == null && CombRLC.root.getNVertFict(1) <= 3);
        this.pan.repaint();
    }

    void updateAll() {
        this.cv.repaint();
        this.updatePanel();
        this.cv.requestFocus();
    }

    void arrange() {
        CombRLC r = CombRLC.root;
        int n = r.getNVert() + 1;
        int yOR = n < 4 ? 20 : 0;
        r.arrange(60, yOR, 480, 350 * (n - 1) / n);
        this.y0 = yOR + 20 + 350 * (2 * n - 1) / (2 * n);
        this.y1 = r.y + r.h / 2;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.buReset) {
            CombRLC.u0 = 12.0;
            CombRLC.root = CombRLC.current = new Resistor(this.r0);
            this.buSer.setEnabled(true);
            this.buPar.setEnabled(true);
            this.cbU.setSelected(false);
            this.cbI.setSelected(false);
            this.vm = null;
            this.am = null;
        } else if (o == this.buSer) {
            this.r0 = this.inputTF2(this.tfR, 1.0, 1000000.0, 3, 1.0E-6);
            Resistor r = new Resistor(this.r0);
            CombRLC.current.insertSer(r);
        } else if (o == this.buPar) {
            this.r0 = this.inputTF2(this.tfR, 1.0, 1000000.0, 3, 1.0E-6);
            Resistor r = new Resistor(this.r0);
            CombRLC.current.insertPar(r);
        } else if (o == this.tfU) {
            CombRLC.u0 = this.inputTF2(this.tfU, 0.001, 1000.0, 3, 1.0E-6);
        } else if (o == this.tfR) {
            this.r0 = this.inputTF2(this.tfR, 1.0, 1000000.0, 3, 1.0E-6);
            if (CombRLC.current instanceof Resistor) {
                Resistor r = (Resistor)CombRLC.current;
                r.resistance = this.r0;
            }
        } else if (o instanceof JCheckBox) {
            boolean u = this.cbU.isSelected();
            boolean i = this.cbI.isSelected();
            if (this.vm != null) {
                this.vm.remove();
                this.vm = null;
            }
            if (this.am != null) {
                this.am.remove();
                this.am = null;
            }
            if (o == this.cbU) {
                if (u) {
                    if (!i) {
                        this.curr0 = CombRLC.current;
                    }
                    if (i) {
                        this.curr0.insertAM();
                    }
                    this.curr0.insertVM();
                } else if (i) {
                    this.curr0.insertAM();
                }
            } else if (o == this.cbI) {
                if (i) {
                    if (!u) {
                        this.curr0 = CombRLC.current;
                    }
                    if (u) {
                        this.curr0.insertVM();
                    }
                    this.curr0.insertAM();
                } else if (u) {
                    this.curr0.insertVM();
                }
            }
            CombRLC.current = this.curr0;
            this.vm = CombRLC.root.getVoltmeter();
            this.am = CombRLC.root.getAmperemeter();
        }
        this.arrange();
        this.updateAll();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.xMin = this.xMax = me.getX();
        this.yMin = this.yMax = me.getY();
        CombRLC.current = CombRLC.root.selectedPart(this.xMin, this.xMax, this.yMin, this.yMax);
        this.updateAll();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        CombRLC.current = CombRLC.root.selectedPart(this.xMin, this.xMax, this.yMin, this.yMax);
        this.updateAll();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int code = ke.getKeyCode();
        CombRLC c = null;
        switch (code) {
            case 38: {
                c = CombRLC.current.parent;
                break;
            }
            case 40: {
                if (!(CombRLC.current instanceof CombSerPar)) break;
                c = ((CombSerPar)CombRLC.current).first;
                break;
            }
            case 39: {
                c = CombRLC.current.next;
                break;
            }
            case 37: {
                c = CombRLC.current.getPrevious();
            }
        }
        if (c != null) {
            CombRLC.current = c;
        }
        this.updateAll();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, CombinationResistorsAP.this.bgCanvas);
            CombinationResistorsAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void power(Graphics2D g) {
            g.setColor(Color.black);
            int x = 310;
            int h2 = 10;
            CanvasAP.line(g, x, CombinationResistorsAP.this.y0 - 2 * h2, x, CombinationResistorsAP.this.y0 + 2 * h2);
            CanvasAP.line(g, x, CombinationResistorsAP.this.y0, 560.0, CombinationResistorsAP.this.y0);
            CanvasAP.line(g, 560.0, CombinationResistorsAP.this.y0, 560.0, CombinationResistorsAP.this.y1);
            CanvasAP.line(g, 560.0, CombinationResistorsAP.this.y1, 540.0, CombinationResistorsAP.this.y1);
            CanvasAP.rectangle(g, x -= 20, CombinationResistorsAP.this.y0 - h2, 5.0, 2 * h2, Color.black);
            CanvasAP.line(g, x, CombinationResistorsAP.this.y0, 40.0, CombinationResistorsAP.this.y0);
            CanvasAP.line(g, 40.0, CombinationResistorsAP.this.y0, 40.0, CombinationResistorsAP.this.y1);
            CanvasAP.line(g, 40.0, CombinationResistorsAP.this.y1, 60.0, CombinationResistorsAP.this.y1);
        }

        void writeValues(Graphics2D g) {
            CanvasAP.setAntiAliasing(g, false);
            String s = CombinationResistorsAP.this.toString2(CombRLC.u0, 3, 1.0E-6) + " " + CombinationResistorsAP.this.volt;
            int x = 300 - CombinationResistorsAP.this.fmH.stringWidth(s) / 2;
            g.setColor(CombinationResistorsAP.this.colorVoltage);
            g.drawString(s, x, CombinationResistorsAP.this.y0 + 36);
            CombRLC curr = CombRLC.current;
            g.drawString(CombinationResistorsAP.this.text07 + ":", 20, 400);
            s = curr.stringVoltage();
            g.drawString(s, 220, 400);
            g.setColor(CombinationResistorsAP.this.colorAmperage);
            g.drawString(CombinationResistorsAP.this.text08 + ":", 20, 420);
            s = curr.stringAmperage();
            g.drawString(s, 220, 420);
            g.setColor(Color.black);
            s = curr instanceof SingleRLC ? CombinationResistorsAP.this.text09 : CombinationResistorsAP.this.text10;
            g.drawString(s, 20, 440);
            double r = curr.getResistance().abs();
            s = r == 0.0 ? CombinationResistorsAP.this.text11 : (Double.isInfinite(r) ? CombinationResistorsAP.this.text12 : CombinationResistorsAP.this.toString2(r, 3, 1.0E-6) + " " + CombinationResistorsAP.this.ohm);
            g.drawString(s, 220, 440);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            CombRLC.fmH = CombinationResistorsAP.this.fmH;
            CombRLC.root.paint(g2);
            this.power(g2);
            this.writeValues(g2);
        }
    }
}

