/*
 * Decompiled with CFR 0.152.
 */
public class Complex {
    double re;
    double im;

    Complex(double r, double i) {
        this.re = r;
        this.im = i;
    }

    Complex(double r) {
        this(r, 0.0);
    }

    Complex() {
        this(0.0, 0.0);
    }

    Complex add(Complex c) {
        Complex res = new Complex(this.re, this.im);
        res.re += c.re;
        res.im += c.im;
        return res;
    }

    Complex sub(Complex c) {
        Complex res = new Complex(this.re, this.im);
        res.re -= c.re;
        res.im -= c.im;
        return res;
    }

    Complex mul(Complex c) {
        Complex res = new Complex();
        res.re = this.re * c.re - this.im * c.im;
        res.im = this.re * c.im + this.im * c.re;
        return res;
    }

    Complex div(Complex c) {
        Complex res = new Complex();
        double denom = c.re * c.re + c.im * c.im;
        res.re = (this.re * c.re + this.im * c.im) / denom;
        res.im = (this.im * c.re - this.re * c.im) / denom;
        return res;
    }

    double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }
}

